yield = readxl::read_excel(
  'DataSets.xlsx',
  sheet = 'anova',
  range = 'V10:Z106'
)

vars = c('replication', 'density',
         'variety', 'fertilizer')
yield[vars] = lapply(yield[vars], factor)

# interactive 4-way anova
mod4 = aov(yield ~ replication*density*variety*fertilizer, yield)
summary(mod4)

# full model
mod5 = aov(yield ~ replication + density + variety + fertilizer +
             replication:density + replication:variety + replication:fertilizer +
             density:variety + density:fertilizer +
             variety:fertilizer, data = yield)
summary(mod5)

# reduced model
mod6 = aov(yield ~ replication + density + fertilizer,
           data = yield)
summary(mod6)

# post hoc using DMRT
library(agricolae)
dm = duncan.test(mod6, trt = c('replication', 'density', 'fertilizer'))
dm$means
dm$groups

# Tukey is less sensitive for small samples than DMRT
tk = HSD.test(mod6, trt = c('replication', 'density', 'fertilizer'))
tk$means
tk$groups

